<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Banner extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "banner";
        $this->data["sub_menu"] = "";
        $this->load->model("banner_model", "banner");
    }

    public function index() {
        $this->data["title"] = "banners";
        $this->data["data"] = $this->banner->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('banner/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "banners";
        $this->load->view('template/header', $this->data);
        $this->load->view('banner/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->banner->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "banners";
        $this->data["data"] = $this->banner->get_by_id($id);

        $this->load->view('template/header', $this->data);
        $this->load->view('banner/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->banner->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->banner->delete($id);

        echo json_encode($data);
    }

}
