<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Sub_categories extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "sub_categories";
        $this->data["sub_menu"] = "";
        $this->load->model("sub_categories_model", "sub_categorie");
        $this->load->model("categories_model", "categorie");
    }

    public function index() {
        $this->data["title"] = "sub categories";
        $this->data["data"] = $this->sub_categorie->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('sub_categories/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "sub categories";
        $this->data["categorie"] = $this->categorie->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('sub_categories/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->sub_categorie->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "sub categories";
        $this->data["data"] = $this->sub_categorie->get_by_id($id);
        $this->data["categorie"] = $this->categorie->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('sub_categories/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->sub_categorie->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->sub_categorie->delete($id);

        echo json_encode($data);
    }

    public function get_sub_by_cate($cate_id) {
        $data = $this->sub_categorie->get_sub_by_cate($cate_id);

        echo json_encode($data);
    }

}
