<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Sub_categories2 extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "sub_categories2";
        $this->data["sub_menu"] = "";
//        $this->load->model("categories_model", "categorie");
        $this->load->model("sub_categories_model", "sub_categorie");
        $this->load->model("sub_categories2_model", "sub_categorie2");
    }

    public function index() {
        $this->data["title"] = "Nested categories";
        $this->data["data"] = $this->sub_categorie2->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('sub_categories2/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "Nested categories";
        $this->data["sub_categorie"] = $this->sub_categorie->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('sub_categories2/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->sub_categorie2->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "Nested categories";
        $this->data["data"] = $this->sub_categorie2->get_by_id($id);
        $this->data["sub_categorie"] = $this->sub_categorie->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('sub_categories2/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->sub_categorie2->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->sub_categorie2->delete($id);

        echo json_encode($data);
    }
    
    public function get_sub_by_cate($cate_id) {
        $data = $this->sub_categorie2->get_sub_by_cate($cate_id);

        echo json_encode($data);
    }

}
