<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Vdo extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "Video";
        $this->data["sub_menu"] = "";
        $this->load->model("vdo_model", "vdo");
    }

    public function index() {
        $this->data["title"] = "Video";
        $this->data["data"] = $this->vdo->get_by_id("000001");

        $this->load->view('template/header', $this->data);
        $this->load->view('vdo/index');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->vdo->update();

        echo json_encode($data);
    }

}
