<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class News_model extends CI_Model {

    protected $table = "news";

    public function __construct() {
        parent::__construct();
    }

    public function create() {
        $response = array();
        $date_arr = explode("-", $_POST["create_date"]);
        $date = $date_arr[2] . "-" . $date_arr[1] . "-" . $date_arr[0];
        $fields = array(
            'title_th' => htmlspecialchars($_POST["title_th"]),
            'title_en' => htmlspecialchars($_POST["title_en"]),
            'short_detail_th' => htmlspecialchars($_POST["short_description_th"]),
            'short_detail_en' => htmlspecialchars($_POST["short_description_en"]),
            'detail_th' => htmlspecialchars($_POST["description_th"]),
            'detail_en' => htmlspecialchars($_POST["description_en"]),
            'create' => $date,
            'status' => $_POST["status"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->insert($this->table, $fields);
        $data = $this->get_by_id($this->db->insert_id());
        if (!empty($_FILES["upload_img"]["name"])) {
            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/news/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/news/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function update() {
        $response = array();
        $date_arr = explode("-", $_POST["create_date"]);
        $date = $date_arr[2] . "-" . $date_arr[1] . "-" . $date_arr[0];
        $id = $_POST["data_id"];
        $fields = array(
            'title_th' => htmlspecialchars($_POST["title_th"]),
            'title_en' => htmlspecialchars($_POST["title_en"]),
            'short_detail_th' => htmlspecialchars($_POST["short_description_th"]),
            'short_detail_en' => htmlspecialchars($_POST["short_description_en"]),
            'detail_th' => htmlspecialchars($_POST["description_th"]),
            'detail_en' => htmlspecialchars($_POST["description_en"]),
            'create' => $date,
            'status' => $_POST["status"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->where('id', $id);
        $this->db->update($this->table, $fields);

        $data = $this->get_by_id($id);

        if (!empty($_FILES["upload_img"]["name"])) {
            @unlink($data["image"]);
            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/news/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/news/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function delete($id) {
        $data = $this->get_by_id($id);
        $this->db->query("DELETE FROM " . $this->table . " WHERE id = '" . $id . "'");
        if (!empty($data["image"])) {
            delete_files($data["image"]);
        }

        return "success";
    }

    public function get_by_id($id) {
        $response = array();
        $sql = "SELECT
                n.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS n
              INNER JOIN employee AS e
                ON n.employee_id = e.id
              WHERE n.id = '" . $id . "'";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $date_arr = explode("-", $row["create"]);
            $date = $date_arr[2] . "-" . $date_arr[1] . "-" . $date_arr[0];
            $response["id"] = $row["id"];
            $response["title_th"] = htmlspecialchars_decode($row["title_th"]);
            $response["title_en"] = htmlspecialchars_decode($row["title_en"]);
            $response["short_detail_th"] = htmlspecialchars_decode($row["short_detail_th"]);
            $response["short_detail_en"] = htmlspecialchars_decode($row["short_detail_en"]);
            $response["detail_th"] = htmlspecialchars_decode($row["detail_th"]);
            $response["detail_en"] = htmlspecialchars_decode($row["detail_en"]);
            $response["image"] = htmlspecialchars_decode($row["image"]);
            $response["create"] = $date == "00-00-0000" ? date("d-m-Y") : $date;
            $response["status"] = $row["status"];
            $response["create_date"] = format_date_thai($row["create_date"]);
            $response["modify_date"] = format_date_thai($row["modify_date"]);
            $response["employee"] = $row["firstname"] . " " . $row["lastname"];
        }

        return $response;
    }

    public function get_all() {
        $response = array();
        $sql = "SELECT
                n.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS n
              INNER JOIN employee AS e
                ON n.employee_id = e.id
              ORDER BY n.create DESC, n.create_date DESC, n.id DESC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $date_arr = explode("-", $row["create"]);
            $date = $date_arr[2] . "-" . $date_arr[1] . "-" . $date_arr[0];
            array_push($response, array(
                "id" => $row["id"],
                "title_th" => htmlspecialchars_decode($row["title_th"]),
                "title_en" => htmlspecialchars_decode($row["title_en"]),
                "short_detail_th" => htmlspecialchars_decode($row["short_detail_th"]),
                "short_detail_en" => htmlspecialchars_decode($row["short_detail_en"]),
                "detail_th" => htmlspecialchars_decode($row["detail_th"]),
                "detail_en" => htmlspecialchars_decode($row["detail_en"]),
                "image" => htmlspecialchars_decode($row["image"]),
                "create" => $date,
                "status" => $row["status"],
                "create_date" => format_date_thai($row["create_date"]),
                "modify_date" => format_date_thai($row["modify_date"]),
                "employee" => $row["firstname"] . " " . $row["lastname"]
            ));
        }

        return $response;
    }

}
