<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Sub_categories2_model extends CI_Model {

    protected $table = "sub_categories_2";

    public function __construct() {
        parent::__construct();
    }

    public function create() {
        $response = array();
        $rank = count($this->get_all()) + 1;
        $fields = array(
            'title' => htmlspecialchars($_POST["title"]),
            'sub_categories_id' => $_POST["sub_categories_id"],
            'status' => $_POST["status"],
            'rank' => $rank,
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->insert($this->table, $fields);
        $data = $this->get_by_id($this->db->insert_id());


        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function update() {
        $response = array();
        $id = $_POST["data_id"];
        $fields = array(
            'title' => htmlspecialchars($_POST["title"]),
            'sub_categories_id' => $_POST["sub_categories_id"],
            'status' => $_POST["status"],
            'rank' => $_POST["rank"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->where('id', $id);
        $this->db->update($this->table, $fields);

        $data = $this->get_by_id($id);

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function delete($id) {
        $query_p = $this->db->query("SELECT * FROM products WHERE sub_cate_id = '" . $id . "'");
        foreach ($query_p->result_array() as $row_p) {
            if (!empty($row_p["image"])) {
                delete_files($row_p["image"]);
            }
            if (!empty($row_p["pdf"])) {
                delete_files($row_p["pdf"]);
            }
        }

        $this->db->query("DELETE FROM " . $this->table . " WHERE id = '" . $id . "'");

        return "success";
    }

    public function get_by_id($id) {
        $response = array();
        $sql = "SELECT
                n.*,
                c.title AS categories,
                s.id AS sub_categories_id,
                s.title AS sub_categories,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS n
              INNER JOIN sub_categories AS s
                ON n.sub_categories_id = s.id
              INNER JOIN categories AS c
                ON s.categories_id = c.id
              INNER JOIN employee AS e
                ON s.employee_id = e.id
              WHERE n.id = '" . $id . "'
              ORDER BY s.rank ASC, s.id ASC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $response["id"] = $row["id"];
            $response["title"] = htmlspecialchars_decode($row["title"]);
            $response["sub_categories_id"] = $row["sub_categories_id"];
            $response["status"] = $row["status"];
            $response["rank"] = $row["rank"];
            $response["create_date"] = format_date_thai($row["create_date"]);
            $response["modify_date"] = format_date_thai($row["modify_date"]);
            $response["employee"] = $row["firstname"] . " " . $row["lastname"];
        }

        return $response;
    }

    public function get_all() {
        $response = array();

        $sql = "SELECT
                n.*,
                c.title AS categories,
                s.title AS sub_categories,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS n
              INNER JOIN sub_categories AS s
                ON n.sub_categories_id = s.id
              INNER JOIN categories AS c
                ON s.categories_id = c.id
              INNER JOIN employee AS e
                ON s.employee_id = e.id
              ORDER BY s.rank ASC, s.id ASC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            array_push($response, array(
                "id" => $row["id"],
                "categories" => htmlspecialchars_decode($row["categories"]),
                "sub_categories" => htmlspecialchars_decode($row["sub_categories"]),
                "title" => htmlspecialchars_decode($row["title"]),
                "status" => $row["status"],
                "rank" => $row["rank"],
                "create_date" => format_date_thai($row["create_date"]),
                "modify_date" => format_date_thai($row["modify_date"]),
                "employee" => $row["firstname"] . " " . $row["lastname"]
            ));
        }

        return $response;
    }

    public function get_sub_by_cate($cate_id) {
        $response = array();

        $sql = "SELECT
                n.*,
                c.title AS categories,
                s.title AS sub_categories,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS n
              INNER JOIN sub_categories AS s
                ON n.sub_categories_id = s.id
              INNER JOIN categories AS c
                ON s.categories_id = c.id
              INNER JOIN employee AS e
                ON s.employee_id = e.id
              WHERE s.id='" . $cate_id . "'
              ORDER BY s.rank ASC, s.id ASC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            array_push($response, array(
                "id" => $row["id"],
                "categories" => htmlspecialchars_decode($row["categories"]),
                "sub_categories" => htmlspecialchars_decode($row["sub_categories"]),
                "title" => htmlspecialchars_decode($row["title"]),
                "status" => $row["status"],
                "rank" => $row["rank"],
                "create_date" => format_date_thai($row["create_date"]),
                "modify_date" => format_date_thai($row["modify_date"]),
                "employee" => $row["firstname"] . " " . $row["lastname"]
            ));
        }

        return $response;
    }

}
