<!-- Page Heading -->
<div class="row">
    <div class="col-lg-12">
        <h1 class="page-header"><?= $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <i class="fa fa-list-ul" aria-hidden="true"></i> <a href="<?= base_url("index.php/customer"); ?>"><?= $title; ?></a>
            </li>
            <li class="active">
                <i class="fa fa-edit"></i> create customer
            </li>
        </ol>
    </div>
</div>
<!-- /.row -->

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-body">
                <?= form_open_multipart('customer/do_create', array('id' => 'customer', 'class' => 'form-horizontal', 'onsubmit' => 'return false')); ?>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Image</label>
                    <div class="col-sm-10">
                        <input id="upload_img" name="upload_img" placeholder="true" data-show-upload="false" type="file" placeholder="Select image..." >
                        <div id="errorBlock" class="help-block"></div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Type
                        <br>
                    </label>
                    <div class="col-sm-10">
                        <div class="radio radio-inline">
                            <input type="radio" id="cus_local" value="0" name="type" checked>
                            <label for="cus_local"> Local </label>
                        </div>
                        <div class="radio radio-inline">
                            <input type="radio" id="cus_overseas" value="1" name="type">
                            <label for="cus_overseas"> Overseas </label>
                        </div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Customer</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="title" name="title" placeholder="Insert customer name..." >
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Link</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="link" name="link" placeholder="Insert link..." >
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Product introduction
                        <br>
                    </label>
                    <div class="col-sm-10">
                        <div class="radio radio-danger radio-inline">
                            <input type="radio" id="introduction_hide" value="0" name="introduction" checked>
                            <label for="introduction_hide"> No </label>
                        </div>
                        <div class="radio radio-info radio-inline">
                            <input type="radio" id="introduction_show" value="1" name="introduction">
                            <label for="introduction_show"> YES </label>
                        </div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Status
                        <br>
                    </label>
                    <div class="col-sm-10">
                        <div class="radio radio-danger radio-inline">
                            <input type="radio" id="status_hide" value="0" name="status" checked>
                            <label for="status_hide"> Hide </label>
                        </div>
                        <div class="radio radio-info radio-inline">
                            <input type="radio" id="status_show" value="1" name="status">
                            <label for="status_show"> Show </label>
                        </div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group" style="display: none;" id="blog_error">
                    <label class="col-sm-2 control-label"></label>
                    <div class="col-sm-10">
                        <div class="alert alert-danger" role="alert">
                            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                            <span class="sr-only">Error:</span><span id="txt_error"></span>
                        </div>
                    </div>
                </div>
                <div class="progress" style="display: none;">
                    <div class="progress-bar progress-bar-success progress-bar-striped" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:0%"></div>
                </div>
                <div class="form-group">
                    <div class="col-sm-8 col-sm-offset-2">
                        <button class="btn btn-success" type="submit" onclick="customer('add');"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</button>
                        <button class="btn btn-default" type="reset"><i class="fa fa-ban" aria-hidden="true"></i> Cancel</button>
                    </div>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>