<!-- Page Heading -->
<div class="row">
    <div class="col-lg-12">
        <h1 class="page-header"><?= $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <i class="fa fa-list-ul" aria-hidden="true"></i> <a href="<?= base_url("index.php/sub_categories2"); ?>"><?= $title; ?></a>
            </li>
            <li class="active">
                <i class="fa fa-edit"></i> Update nested categories
            </li>
        </ol>
    </div>
</div>
<!-- /.row -->
<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-body">
                <?= form_open_multipart('sub_categories2/do_update', array('id' => 'sub_categories2', 'class' => 'form-horizontal', 'onsubmit' => 'return false')); ?>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Categories</label>
                    <div class="col-sm-10">
                        <input type="hidden" id="data_id" name="data_id" value="<?= $data["id"]; ?>" />
                        <select class="form-control" id="sub_categories_id" name="sub_categories_id">
                            <option value="">--Please select--</option>
                            <?php
                            foreach ($sub_categorie as $arr_sub_categorie) {
                                $selected = "";
                                if ($data["sub_categories_id"] == $arr_sub_categorie["id"]) {
                                    $selected = "selected";
                                }
                                ?>
                                <option <?= $selected; ?> value="<?= $arr_sub_categorie["id"]; ?>"><?= $arr_sub_categorie["title"]; ?></option>
                                <?php
                            }
                            ?>
                        </select>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Sub categories</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="title" name="title" placeholder="Insert sub categories..." value="<?= $data["title"]; ?>" />
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Ranking</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="rank" name="rank" placeholder="Insert sub ranking..." value="<?= $data["rank"]; ?>" />
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Status
                        <br>
                    </label>
                    <div class="col-sm-10">
                        <div class="radio radio-danger radio-inline">
                            <input type="radio" id="status_hide" value="0" name="status" <?= $data["status"] == "0" ? "checked" : ""; ?> />
                            <label for="status_hide"> Hide </label>
                        </div>
                        <div class="radio radio-info radio-inline">
                            <input type="radio" id="status_show" value="1" name="status" <?= $data["status"] == "1" ? "checked" : ""; ?> />
                            <label for="status_show"> Show </label>
                        </div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Create date</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="<?= $data["create_date"]; ?>" disabled="" />
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <?php if ($data["modify_date"] != "00/00/0000 00:00:00") { ?>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Modify date</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" value="<?= $data["modify_date"]; ?>" disabled="" />
                        </div>
                    </div>
                    <div class="hr-dashed"></div>
                <?php } ?>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Employee modify</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="<?= $data["employee"]; ?>" disabled="" />
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group" style="display: none;" id="blog_error">
                    <label class="col-sm-2 control-label"></label>
                    <div class="col-sm-10">
                        <div class="alert alert-danger" role="alert">
                            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                            <span class="sr-only">Error:</span><span id="txt_error"></span>
                        </div>
                    </div>
                </div>
                <div class="progress" style="display: none;">
                    <div class="progress-bar progress-bar-success progress-bar-striped" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:0%"></div>
                </div>
                <div class="form-group">
                    <div class="col-sm-8 col-sm-offset-2">
                        <button class="btn btn-success" type="submit" onclick="sub_categories2();"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</button>
                        <button class="btn btn-default" type="reset"><i class="fa fa-ban" aria-hidden="true"></i> Cancel</button>
                    </div>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>