$(document).ready(function () {
    startUp();
});

function startUp() {
    $('#zctb').DataTable();
    $("#upload_img").fileinput({
        showPreview: false,
        allowedFileExtensions: ["jpg", "jpeg", "png", "gif"],
        elErrorContainer: "#errorBlock"
    });

    $("#pdf_file").fileinput({
        showPreview: false,
        showCaption: true,
        allowedFileExtensions: ["pdf"],
        elErrorContainer: "#errorBlockPDF"
    });


    $(".popupImg").fancybox({
        openEffect: 'none',
        closeEffect: 'none'
    });

    $('#create input').datepicker({
        format: "dd-mm-yyyy",
        autoclose: true,
        todayHighlight: true
    });
}

function login() {
    var email = $("#email").val();
    var pass = $("#password").val();
    if (email === "" && pass === "") {
        $("#email").focus();
        $("#blog_error").show();
        $("#txt_error").html("กรุณากรอก Email และ Password");
    } else if (!isValidEmail(email)) {
        $("#email").focus();
        $("#blog_error").show();
        $("#txt_error").html("รูปแบบ Email ไม่ถูกต้องกรูณาตรวจสอบ");
    } else {
        $.ajax({
            url: base_url + "index.php/admin/do_login",
            type: "POST",
            data: {
                email: email,
                password: pass
            },
            dataType: "json",
            success: function (data) {
                if (data === "not_found") {
                    $("#email").focus();
                    $("#blog_error").show();
                    $("#txt_error").html("ข้อมูลไม่ถูกต้อง กรุณาตวจสอบข้อมูล");
                } else if (data === "disable") {
                    $("#email").focus();
                    $("#blog_error").show();
                    $("#txt_error").html("บัญชีนี้ถูกระงับการใช้งาน");
                } else if (data === "success") {
                    window.location.href = base_url + "index.php/home";
                }
            }
        });
    }
}

function banner(mode) {
    $("#banner").removeAttr("onsubmit");
    $("#banner").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#upload_img").val() === "" && mode === "add") {
                $("#upload_img").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please select image banner.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/banner/update/" + data["id"];
            }
        }
    });
}

function categories() {
    $("#categories").removeAttr("onsubmit");
    $("#categories").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#title").val() === "") {
                $("#title").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please insert categories.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/categories/update/" + data["id"];
            }
        }
    });
}

function sub_categories() {
    $("#sub_categories").removeAttr("onsubmit");
    $("#sub_categories").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#categories_id").val() === "") {
                $("#categories_id").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please select categories.");
                return false;
            } else if ($("#title").val() === "") {
                $("#title").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please insert sub categories.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/sub_categories/update/" + data["id"];
            }
        }
    });
}

function sub_categories2() {
    $("#sub_categories2").removeAttr("onsubmit");
    $("#sub_categories2").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#sub_categories_id").val() === "") {
                $("#sub_categories_id").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please select sub categories.");
                return false;
            } else if ($("#title").val() === "") {
                $("#title").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please insert nested categories.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data.response === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/sub_categories2/update/" + data.id;
            }
        }
    });
}

function careers() {
    $("#form_course").removeAttr("onsubmit");
    $("#career").ajaxForm({
        dataType: 'json',
        data: {
            detail_en: CKEDITOR.instances["detail_en"].getData(),
            detail_th: CKEDITOR.instances["detail_th"].getData(),
            contact_en: CKEDITOR.instances["contact_en"].getData(),
            contact_th: CKEDITOR.instances["contact_th"].getData()
        },
        beforeSubmit: function () {
            if ($("#position_en").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ ตำแหน่งงาน(EN)");
                return false;
            } else if ($("#position_th").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ ตำแหน่งงาน(TH)");
                return false;
            } else if ($("#company_en").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ บริษัท(EN)");
                return false;
            } else if ($("#company_th").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ บริษัท(TH)");
                return false;
            } else if ($("#location_en").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ สถานที่ทำงาน(EN)");
                return false;
            } else if ($("#location_th").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ สถานที่ทำงาน(TH)");
                return false;
            } else if (CKEDITOR.instances["detail_en"].getData() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ คุณสมบัติผู้สมัครงาน(EN)");
                return false;
            } else if (CKEDITOR.instances["detail_th"].getData() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ คุณสมบัติผู้สมัครงาน(TH)");
                return false;
            } else if (CKEDITOR.instances["contact_en"].getData() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ ติดต่อสอบถาม(EN)");
                return false;
            } else if (CKEDITOR.instances["contact_th"].getData() === "") {
                $("#blog_error").show();
                $("#txt_error").html("กรุณาระบุ ติดต่อสอบถาม(TH)");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "careers/update/" + data["id"];
            }
        }
    });
}

function deleted(url, text) {
    if (confirm("คุณต้องการลบ '" + text + "' ใช่ หรือ ไม่?")) {
        $.ajax({
            url: url,
            type: "POST",
            dataType: "json",
            success: function (data) {
                if (data === "success") {
                    window.location.reload();
                }
            }
        });
    }
}

function logout() {
    $.ajax({
        url: base_url + "index.php/admin/logout",
        type: "POST",
        dataType: "json",
        success: function (data) {
            if (data === "success") {
                window.location.href = base_url + "index.php/admin/login";
            }
        }
    });
}

function produtcs(mode) {
    var short_description = CKEDITOR.instances["short_description"].getData();
    var description = CKEDITOR.instances["description"].getData();
    $("#products").removeAttr("onsubmit");
    $("#products").ajaxForm({
        data: {
            description: description,
            short_description: short_description
        },
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#categorie").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please select categorie.");
                return false;
            } else if ($("#sub_categorie_id").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please select sub categorie.");
                return false;
            } else if ($("#sub_categorie2").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please select nested categorie.");
                return false;
            } else if ($("#upload_img").val() === "" && mode === "add") {
                $("#blog_error").show();
                $("#txt_error").html("Please select image product.");
                return false;
            } else if ($("#product").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert product name.");
                return false;
            } else if ($("#model").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert model.");
                return false;
            } else if (short_description === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert short description.");
                return false;
            } else if (description === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert description.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/products/update/" + data["id"];
            }
        }
    });
}

function news(mode) {
    var description_th = CKEDITOR.instances["description_th"].getData();
    var description_en = CKEDITOR.instances["description_en"].getData();
    $("#news").removeAttr("onsubmit");
    $("#news").ajaxForm({
        data: {
            description_th: description_th,
            description_en: description_en
        },
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#upload_img").val() === "" && mode === "add") {
                $("#blog_error").show();
                $("#txt_error").html("Please select image product.");
                return false;
            } else if ($("#title_th").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert news(TH).");
                return false;
            } else if ($("#title_en").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert news(EN).");
                return false;
            } else if ($("#short_description_th").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert short description(TH).");
                return false;
            } else if ($("#short_description_en").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert short description(EN).");
                return false;
            } else if (description_th === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert description(TH).");
                return false;
            } else if (description_en === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert description(EN).");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/news/update/" + data["id"];
            }
        }
    });
}

function events(mode) {
    var description_th = CKEDITOR.instances["description_th"].getData();
    var description_en = CKEDITOR.instances["description_en"].getData();
    $("#events").removeAttr("onsubmit");
    $("#events").ajaxForm({
        data: {
            description_th: description_th,
            description_en: description_en
        },
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#upload_img").val() === "" && mode === "add") {
                $("#blog_error").show();
                $("#txt_error").html("Please select image product.");
                return false;
            } else if ($("#title_th").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert events(TH).");
                return false;
            } else if ($("#title_en").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert events(EN).");
                return false;
            } else if ($("#short_description_th").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert short description(TH).");
                return false;
            } else if ($("#short_description_en").val() === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert short description(EN).");
                return false;
            } else if (description_th === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert description(TH).");
                return false;
            } else if (description_en === "") {
                $("#blog_error").show();
                $("#txt_error").html("Please insert description(EN).");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/events/update/" + data["id"];
            }
        }
    });
}

function isValidEmail(str) {
    var filter = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
    return (filter.test(str));
}

function vdo() {
    $("#vdo").removeAttr("onsubmit");
    $("#vdo").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#link").val() === "") {
                $("#link").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please insert link youtube.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.reload();
            }
        }
    });
}

function customer(mode) {
    $("#customer").removeAttr("onsubmit");
    $("#customer").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#upload_img").val() === "" && mode === "add") {
                $("#upload_img").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please select image.");
                return false;
            } else if ($("#title").val() === "") {
                $("#title").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please insert customer name.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/customer/update/" + data["id"];
            }
        }
    });
}

function get_subcate(cate_id) {
    $.ajax({
        url: base_url + "index.php/sub_categories/get_sub_by_cate/" + cate_id,
        type: "POST",
        dataType: "json",
        success: function (data) {
            var sub_cate_html = '<option value="">--Please select--</option>';
            for (var i = 0; i < data.length; i++) {
                sub_cate_html += '<option value="' + data[i].id + '">' + data[i].title + '</option>';
            }
            $("#sub_categorie_id").html(sub_cate_html);
        }
    });
}

function get_sub_cate2(cate_id) {
    $.ajax({
        url: base_url + "index.php/sub_categories2/get_sub_by_cate/" + cate_id,
        type: "POST",
        dataType: "json",
        success: function (data) {
            var sub_cate2_html = '<option value="">--Please select--</option>';
            for (var i = 0; i < data.length; i++) {
                sub_cate2_html += '<option value="' + data[i].id + '">' + data[i].title + '</option>';
            }
            $("#sub_categorie2").html(sub_cate2_html);
        }
    });
}

function certificates(mode) {
    $("#f_certificates").removeAttr("onsubmit");
    $("#f_certificates").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#upload_img").val() === "" && mode === "add") {
                $("#upload_img").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please select image certificates.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/certificates/update/" + data["id"];
            }
        }
    });
}

function reference(mode) {
    $("#f_reference").removeAttr("onsubmit");
    $("#f_reference").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#upload_img").val() === "" && mode === "add") {
                $("#upload_img").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please select image reference.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/reference/update/" + data["id"];
            }
        }
    });
}

function iso_cer(mode) {
    $("#iso_cer").removeAttr("onsubmit");
    $("#iso_cer").ajaxForm({
        dataType: 'json',
        beforeSubmit: function () {
            if ($("#title").val() === "") {
                $("#title").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please insert iso.");
                return false;
            } else if ($("#upload_img").val() === "" && mode === "add") {
                $("#upload_img").focus();
                $("#blog_error").show();
                $("#txt_error").html("Please select image reference.");
                return false;
            } else {
                $(".progress").show();
                $("#blog_error").hide();
                $("#txt_error").html("");
            }
        },
        uploadProgress: function (event, position, total, percentComplete) {
            $(".progress-bar").width(percentComplete + '%');
            $(".progress-bar").html(percentComplete + '%');
        },
        success: function (data) {
            if (data["response"] === "success") {
                setTimeout(function () {
                    $(".progress").hide();
                    $(".progress-bar").width('0%');
                    $(".progress-bar").html('0%');
                }, 100);
                window.location.href = base_url + "index.php/iso_cer/update/" + data["id"];
            }
        }
    });
}